<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Projects extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'slack_id', 'red_pill_link', 'type', 'status', 'pm_id', 'dm_id', 'created_by', 'updated_by');

    public function getPM()
    {
        return $this->hasOne('User', 'pm_id');
    }

    public function getDM()
    {
        return $this->hasOne('User', 'dm_id');
    }

}